<!DOCTYPE html>
<html lang="en">
<head>
	<meta charset="utf-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<title>Proyecto</title>
	<link href="../js/js/bootstrap/css/bootstrap.css" rel="stylesheet" media="screen" />
	<link href="../css/style.css" rel="stylesheet" media="screen" />
	<link rel="stylesheet" type="text/css" href="../css/dataTables.bootstrap.css">
</head>
<body>
	<div class="container">
		<div class="margin-bottom-1em overflow-hidden">
			<div id="read" class="btn btn-primary pull-right">
				<span class="glyphicon glyphicon-list"></span> Listar Proyecto
			</div>
			<div id="create" class="btn btn-primary pull-right">
				<span class="glyphicon glyphicon-plus"></span> Crear Proyecto
			</div>
			<div id="loader-image" class="loading-gif"></div>
		</div>
		<div class="page-header">
			<h1 id="page-title"></h1>
		</div>
		<br>
		<div id="message_alerta" style="display:none"></div>
		<div id="page-content"></div>
	</div>
	<script src="../js/js/jquery-3.1.0.js"></script>
	<script src="../js/js/bootstrap/js/bootstrap.min.js"></script>
	<script type="text/javascript" language="javascript" src= "../js/js/jquery-3.1.0.min.js"></script>
	<script type="text/javascript" language="javascript" src= "../js/js/jquery.dataTables.js"></script>
	<script type="text/javascript" language="javascript" src= "../js/js/dataTables.bootstrap.js"></script>
	<script type="text/javascript">
		$(document).ready(function(){
			$("#read").hide();
			$("#create").hide();
			Listar();
			$("#create").click(function(){create();});
			$("#loader-image").show();
			$("#read").click(function(){read();});
			$(document).on("submit", "#create-form", function() {guardarCreate($(this).serialize());return false;});
			$(document).on("click", ".edit-btn", function(){edit($(this).closest("td").find(".id").text());}); 
			$(document).on("click", ".delete-btn", function(){ 
				if(confirm("Esta Seguro que desea Eliminar el Registro?")){
					eliminar($(this).closest("td").find(".id").text());
				}
			});
		});
		function changePageTitle(page_title)
		{
			$("#page-title").text(page_title);
			document.title=page_title;
		}
		function Listar()
		{
			$("#create").show();
			changePageTitle("Lista de proyectos para registrar avances");
			$("#message_alerta").css("display","none");
			$("#page-content").fadeOut("slow", function()
			{
				tabla ="<table class='table table-striped' id='dt_lista_usuarios'>";
				tabla=tabla +"<thead><tr>";
				tabla=tabla +"<th>Nombre Proyecto</th>";
				tabla=tabla +"<th>Etapa</th>";
				tabla=tabla +"<th>Avance Etapa</th>";
				tabla=tabla +"<th data-orderable='false' style='text-align:center;'></th>";
				tabla=tabla +"</tr></thead>";
				tabla=tabla +"<tbody></tbody>";
				tabla=tabla +"</table>";
				$("#loader-image").hide();
				$("#page-content").fadeIn("slow");
				$("#page-content").empty();
				$("#page-content").append(tabla);
				$("#dt_lista_usuarios").DataTable(
				{
					"language":
					{
						"emptyTable":"No hay información disponible",
						"info":"Listado _START_ a _END_ de _TOTAL_ Registros",
						"infoEmpty":"Listado 0 a 0 de 0 Registros",
						"infoFiltered":"(filtrado de _MAX_ registros)",
						"infoPostFix":"",
						"thousands":",",
						"lengthMenu":"Mostrar _MENU_ Registros",
						"loadingRecords": "Cargando...",
						"processing":     "Procesando...",
						"search":         "Buscar:",
						"zeroRecords":    "No se encontraron registros",
						"paginate": {
							"first":      "Primera",
							"last":       "Ultima",
							"next":       "Siguiente",
							"previous":   "Anterior"
						}
					}
				});
				var tabla=$("#dt_lista_usuarios").DataTable();
				$.post("Actualizar.php",{accion:"4"},
					function(data)
					{
						if(data!="0")
						{
							for(var i=0;i<data.length;i++)
							{
								tabla.row.add( 
								[
									data[i].nombreProyecto,
									data[i].etapa,
									data[i].avanceEtapa,
									"<div class='id' style='display:none;' >"+data[i].idProyecto+"</div><button class='btn btn-info edit-btn btn-xs' ><span class='glyphicon glyphicon-pencil'></span> Edit</button>",
								]).draw(false);
							}
						}
						else
						{
							if (data=="0")
							{
								message(3,"No se encontraron Registros.");
							}
							else
							{
								message(4,data);
							}
						}
					},"json");
			});
		}
		function create()
		{
			changePageTitle("Crear Proyecto");
			$("#loader-image").show();
			$("#create").hide();
			$("#read").show();
			$("#page-content").fadeOut("slow", function()
			{
				$("#page-content").load("create.php", function()
				{
					$("#loader-image").hide();
					$("#page-content").fadeIn("slow");
					$("#message_alerta").css("display","none");
				});
			});
		}
		function read()
		{
			$("#loader-image").show();
			$("#create").show();
			$(".modulo").show();
			$("#read").hide();
			Listar();
		}
		function edit(id)
		{
			changePageTitle("Registrar avance en el proyecto");
			$("#loader-image").show();
			$("#create").hide();
			$("#read").show();
			$("#message_alerta").css("display","none");
			$("#page-content").fadeOut("slow", function()
			{
				$("#page-content").load("create_form.php", function()
				{
					$.post("Actualizar.php",{id:id,accion:"3"},
						function(data)
						{
							if(data!="0")
							{
								$("#id").val(data.idProyecto);
								$("#nombreProyecto").val(data.nombreProyecto);
								$("#direccion").val(data.direccion).prop("disabled",true);
								$("#anoEntrega").val(data.anoEntrega).prop("disabled",true);
								$("#etapa").val(data.etapa);
								$("#avanceEtapa").val(data.avanceEtapa);
								$("#areaIntervenir").val(data.areaIntervenir).prop("disabled",true);
								$("#aulasPIA").val(data.aulasPIA).prop("disabled",true);
								$("#aulasPIB").val(data.aulasPIB).prop("disabled",true);
								$("#aulasP").val(data.aulasP).prop("disabled",true);
								$("#aulasS").val(data.aulasS).prop("disabled",true);
								$("#aulasM").val(data.aulasM).prop("disabled",true);
								$("#capacidadAlumnos").val(data.capacidadAlumnos).prop("disabled",true);
								$("#valorOI").val(data.valorOI).prop("disabled",true);
								$("#jardinPI").val(data.jardinPI).prop("disabled",true);
								$("#supervisor").val(data.supervisor).prop("disabled",true);
								$("#imagen").val(data.imagen);
								$("#reportadosEje").val(data.reportadosEje).prop("disabled",true);
								$("#estadoBH").val(data.estadoBH).prop("disabled",true);
								$("#avanceBH").val(data.avanceBH).prop("disabled",true);
								$("#idSede").val(data.idSede).prop("disabled",true);
								$("#idMeta").val(data.idMeta).prop("disabled",true);
								$("#idFinanciacion").val(data.idFinanciacion).prop("disabled",true);
								$("#idCategoria").val(data.idCategoria).prop("disabled",true);
								$("#idEstado").val(data.idEstado).prop("disabled",true);
								$("#update").val('A');//Avance
							}
							else
							{
								if (data=="0")
								{
									message(3,"No se encontraron Registros.");
								}
								else
								{
									message(4,data);
								}
							}
						},"json");
						$("#loader-image").hide();
						$("#page-content").fadeIn("slow");
				});
			});
		}
		function guardarCreate(doc)
		{
			alert($("#accion").val());
			$("#loader-image").show();
			$.post("Actualizar.php",doc,function(data)
			{
				$("#create").show();
				$("#read").hide();
				Listar();
				if(data==1)
				{
					message(1,"Registro Agregado Correctamente.");
				}
				else if(data==3)
				{
					message(1,"Registro Actualizado Correctamente.")
				}
				else if(data==2)
				{
					message(4,"No se puede guardar el registro.")
				}
				else
				{
					message(4,data);
				}
			});
		}
		function eliminar(id)
		{
			$.post("Actualizar.php", { id:id,accion:"2"},function(data)
			{
				$("#loader-image").show();
				Listar();
				if(data==1)
				{
					message(3,"Registro Eliminado Correctamente");
				}
				else if(data==2)
				{
					message(4,"Error al Eliminar el Registro");
				}
				else
				{
					message(4,data);
				}
			});
		}
		function message(tipo,mensaje)
		{
			switch (tipo)
			{
				case(1):
					alerta='<div id="Message" class="alert alert-success alert-dismissable"><button type="button" class="close" data-dismiss="alert">&times;</button>'+mensaje+'</div>';
					break;
				case(2):
					alerta='<div id="Message" class="alert alert-info alert-dismissable"><button type="button" class="close" data-dismiss="alert">&times;</button>'+mensaje+'</div>';
					break;
				case(3):
					alerta='<div id="Message" class="alert alert-warning alert-dismissable"><button type="button" class="close" data-dismiss="alert">&times;</button>'+mensaje+'</div>';
					break;
				case(4):
					alerta='<div id="Message" class="alert alert-warning alert-dismissable"><button type="button" class="close" data-dismiss="alert">&times;</button>'+mensaje+'</div>';
					break;
			}
			$("#message_alerta").html(alerta);
			$("#message_alerta").fadeIn("slow");
				setTimeout(function(){
					$("#message_alerta").fadeOut("slow");
				},5000);
		}
	</script>
</body>
</html>
